% Ossman
% Applies a 7x7 moving average filter to a color image to blur it

X = imread('Butterfly.JPG');  % jpg must be in current folder
imshow(X); title('Original Image');

X_Double = double(X);  % Need to convert to double to multiply pixels by non-ints
Blur = zeros(size(X_Double));

Filter = 1/49*ones(7,7);  % Moving Average Filter

[Rows Cols Panes] = size(X_Double);

for p = 1:Panes
    for r = 4:Rows-3
        for c = 4:Cols-3
            Blur(r,c,p) = sum(sum(Filter.*X_Double(r-3:r+3,c-3:c+3,p)));
        end
    end
end

figure;
Blur = uint8(Blur);  % Convert back to unit8 type
imshow(Blur); title('Blurred Image');


        